% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ici_escal.R
\name{ici_escal}
\alias{ici_escal}
\title{Integral Condition Index Scaling}
\usage{
ici_escal(data = NULL, esc = c(1, 5), ...)
}
\arguments{
\item{data}{Excel book with its extension.}

\item{esc}{Vector with the lower and upper limits of the final scale (def: c(1, 5)).}

\item{...}{Additional argument when data is read from Google Sheets. ID: Id of the Google Sheets.}
}
\value{
Consensuated scaled median scores.
}
\description{
Consensuates and scales the category scores of a variable.
}
\examples{
# NOTICE: Given that Excel files are not R objects, but external files, they cannot be
# loaded into memory when ici package is attached. So, in order to run examples
# you must make Excel files available by locating them on your working directory path.
# You can find Excel files in the 'extdata/' directory within the installed package
# on your local drive. You can also download them through the book:
# https://bookdown.org/gcorrea/ICI/ICIresources.rar.
#
# Example 1: Scores scaled between 1 and 5 (by default)
ici_escal("ici_escal.xlsx")

# Example 2: Scores scaled between 0 and 7
ici_escal("ici_escal.xlsx", esc = c(0, 7))

# Example 3: Same scores for all categories
ici_escal("ici_escal.xlsx", sheet = 3)
}
\references{
Correa-Londoño, G. (2023). Índice de Condición Integral. https://bookdown.org/gcorrea/ICI/.
}
\seealso{
\link{ici} for calculating the ICI, and \link{ici_pond} for consensuating and
scaling the weights of some variables on a complex construct.
}
\author{
Guillermo Correa (gcorrea@unal.edu.co)
}
