% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ici_radarchart.R
\name{ici_radarchart}
\alias{ici_radarchart}
\title{Radar Chart for a set of Evaluation Units}
\usage{
ici_radarchart(
  data,
  minmax,
  dim.char,
  calc.ici,
  plty = 1,
  cglty = 1,
  cglcol = "gray",
  axislabcol = "gray",
  calcex = 0.7,
  pcol = NULL,
  transp = 0.1,
  ...
)
}
\arguments{
\item{data}{Data frame produced by the ici function}

\item{minmax}{A two values vector with minimum and maximum of the scale}

\item{dim.char}{Number of dimensions to be plotted in the radar chart}

\item{calc.ici}{Logical variable indicatig wheter ici was calculated or not}

\item{plty}{A vector of line types for data borders plot (def: 1)}

\item{cglty}{Line type for radar grids (def: 1)}

\item{cglcol}{Line color for radar grids (def: "gray")}

\item{axislabcol}{Color of radar axis labeles (def: "gray")}

\item{calcex}{Font size magnification for radar axis labes (def: 0.7)}

\item{pcol}{A vector of color codes for data borders and fill}

\item{transp}{Tranparency factor for polygons fill (def: 0.1)}

\item{...}{Other customizable parameters from fmsb::radchart function}
}
\value{
A radar chart for the (k-1)-hierarchy constructs.
}
\description{
This function is a wrapper for fmsb::radarchart. Normally, it is automatically
called from within ici function (radarchart = TRUE). Even though, if some
parameters need to be modified, it can be directly called.
}
\details{
Draws a radar chart for the dimensions of some evaluation units.
}
\examples{
# NOTICE: Given that Excel files are not R objects, but external files, they cannot be
# loaded into memory when ici package is attached. So, in order to run examples
# you must make Excel files available by locating them on your working directory path.
# You can find Excel files in the 'extdata/' directory within the installed package
# on your local drive. You can also download them through the book:
# https://bookdown.org/gcorrea/ICI/ICIresources.rar.
#
# Example 1a: Default radar chart por example 1 of the book
# This is what ici function makes by default, when calls ici_radarchart
res1a <- ici("Eje1m.xlsx", ue = 2, radar = F)  # Creates an output data frame
ici_radarchart(res1a, minmax = c(1, 5), dim.char = 4, calc.ici = T)

# Example 1b: Default radar chart por example 1 of the book scaled from 0 to 100
# This is what ici function makes by default, when calls ici_radarchart
res1b <- ici("Eje1m.xlsx", ue = 2, esc = c(1, 5, 0, 100), radar = F)  # Output data frame
ici_radarchart(res1b, minmax = c(0, 100), dim.char = 4, calc.ici = T)

# Example 1c: A radar chart for the same data, with some customization
ici_radarchart(res1b, minmax = c(0, 100), dim.char = 4, calc.ici = T,
cglcol = "pink", axislabcol = "red", pcol = c("blue", "orange"),
transp = 0.2,
vlabels = c("Dim.\nAmbiental", "Dim.\nTécnica",
            "Dim.\nSocial","Dim.\nEconómica"), vlcex = 0.7)

# Example 2a:  Default radar chart por example 2 of the book
res2 <- ici("Eje2m.xlsx", ue = 2, esc = c(1, 5, 0, 100), nc = 4, radar = F)
ici_radarchart(res2, minmax = c(0, 100), dim.char = 3, calc.ici = T)

# Example 2b: A radar chart for the same data, with some customization
ici_radarchart(res2, minmax = c(0, 100), dim.char = 3, calc.ici = T,
              cglty = 3, axislabcol = "blue", calcex = 1.2,
              transp = 0, plwd = 3)
}
\references{
Correa-Londoño, G. (2023). Índice de Condición Integral. https://bookdown.org/gcorrea/ICI/.
}
\seealso{
\link{ici} for calculating the ICI, \link[fmsb:radarchart]{fmsb::radarchart} for drawing a
radar chart.
}
\author{
Guillermo Correa (gcorrea@unal.edu.co)
}
