% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ici_pond.R
\name{ici_pond}
\alias{ici_pond}
\title{Integral Condition Index Weighting}
\usage{
ici_pond(data = NULL, median = T, ...)
}
\arguments{
\item{data}{Excel book with its extension.}

\item{median}{Calculate median weights (def. median = T) or mean weights (median = F).}

\item{...}{Additional argument when data is read from Google Sheets.
ID: Id of the Google Sheets. cons: Create one sheet with the consensus weights (def cons = T).}
}
\value{
Consensus median (or mean) weights.
}
\description{
Consensuates and scales the weights of some variables on a complex construct.
}
\examples{
# NOTICE: Given that Excel files are not R objects, but external files, they cannot be
# loaded into memory when ici package is attached. So, in order to run examples
# you must make Excel files available by locating them on your working directory path.
# You can find Excel files in the 'extdata/' directory within the installed package
# on your local drive. You can also download them through the book:
# https://bookdown.org/gcorrea/ICI/ICIresources.rar.
#
# Example 1: Weights based on median (default)
ici_pond("ici_pond.xlsx")

# Example 2: Weights based on mean (check book for details)
ici_pond("ici_pond.xlsx", median = F)

# Example 3: Equiponderated variables
ici_pond("ici_pond.xlsx", sheet = 3)

# Example 4: Equiponderated variables with some zero-weight variables
ici_pond("ici_pond.xlsx", sheet = 4)

# Example 5: Some zero-weight variables
ici_pond("ici_pond.xlsx", sheet = 5)
}
\references{
Correa-Londoño, G. (2023). Índice de Condición Integral. https://bookdown.org/gcorrea/ICI/.
}
\seealso{
\link{ici} for calculating the ICI, and \link{ici_escal} for consensuating and
scaling the category scores of a variable.
}
\author{
Guillermo Correa (gcorrea@unal.edu.co)
}
